/***************************************************************************
 * SPDX-FileCopyrightText: 2023 {{cookiecutter.author}} {{cookiecutter.email}}
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
#ifndef SKGIMPORTPLUGIN{{cookiecutter.__plugin_slug | upper}}_H
#define SKGIMPORTPLUGIN{{cookiecutter.__plugin_slug | upper}}_H
/** @file
* This file is Skrooge plugin for {{cookiecutter.plugin_name}} import / export.
*
* @author {{cookiecutter.author}}
*/
#include "skgimportplugin.h"

/**
 * This file is Skrooge plugin for {{cookiecutter.plugin_name}} import / export.
 */
class SKGImportPlugin{{cookiecutter.__plugin_slug}} : public SKGImportPlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGImportPlugin);

public:
    /**
     * Default constructor
     * @param iImporter the parent importer
     * @param iArg the arguments
     */
    explicit SKGImportPlugin{{cookiecutter.__plugin_slug}}(QObject* iImporter, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGImportPlugin{{cookiecutter.__plugin_slug}}();

    /**
     * To know if import is possible with this plugin
     */
    virtual bool isImportPossible() override;

    /**
     * Import a file
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError importFile() override;

    /**
     * To know if export is possible with this plugin
     * @return true or false
     */
    virtual bool isExportPossible() override;


    /**
     * Export a file
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError exportFile() override;

    /**
     * Return the mime type filter
     * @return the mime type filter. Example: "*.csv|CSV file"
     */
    virtual QString getMimeTypeFilter() const override;


private:
    Q_DISABLE_COPY(SKGImportPlugin{{cookiecutter.__plugin_slug}});
};

#endif  // SKGIMPORTPLUGIN{{cookiecutter.__plugin_slug | upper}}_H
